# 🚀 Crypto Payments Widget Demo

이 프로젝트는 **Crypto Payments Widget**을 테스트하고 데모할 수 있는 파트너 데모 서버입니다.

## 📁 프로젝트 구조

```
widget-demo/
├── README.md                 # 프로젝트 설명서
├── package.json             # Node.js 의존성 및 스크립트
├── server.js                # Express.js 파트너 데모 서버
├── usage-examples.html      # 위젯 사용 예시 및 테스트 페이지
└── .DS_Store                # macOS 시스템 파일
```

## 🛠️ 설치 및 실행

### 1. 의존성 설치
```bash
cd widget-demo
npm install
```

### 2. 서버 실행
```bash
npm start
# 또는
node server.js
```

### 3. 서버 접속
- **파트너 데모 서버**: http://localhost:3001
- **위젯 사용 예시**: http://localhost:3001/usage-examples
- **헬스체크**: http://localhost:3001/health

## 🌐 API 엔드포인트

### Widget 토큰 발급
```http
POST /api/get-widget-token
Content-Type: application/json

{
  "partnerUserId": "user123",
  "permissions": ["DEPOSIT_READ", "WITHDRAWAL_REQUEST"]
}
```

**응답 예시:**
```json
{
  "token": "eyJhbGciOiJIUzI1NiJ9...",
  "expiresIn": 3600,
  "tokenType": "widget"
}
```

### 파트너 정보 조회
```http
GET /api/partner-info
```

**응답 예시:**
```json
{
  "partnerId": 1,
  "apiKey": "pk_8dc1b3e4a5754daebdac9b174f133e1f",
  "hasSecret": true
}
```

### 헬스체크
```http
GET /health
```

## 🧪 위젯 테스트 가이드

### 1. 기본 테스트 환경 설정

1. **파트너 데모 서버 실행**
   ```bash
   npm start
   ```

2. **위젯 UI 서버 실행** (별도 터미널)
   ```bash
   cd ../widget-ui
   npm run serve
   ```

3. **브라우저에서 테스트 페이지 접속**
   ```
   http://localhost:3001/usage-examples
   ```

### 2. 테스트 시나리오

#### 🎯 입금 위젯 테스트
1. **기본 입금**: "입금 위젯 열기" 버튼 클릭
2. **체인별 테스트**: BSC USDT, ETH USDC, TRON USDT 버튼으로 특정 체인/토큰 테스트
3. **모드별 테스트**: Window/Modal 모드 전환하여 테스트

#### 💰 출금 위젯 테스트
1. **기본 출금**: "출금 위젯 열기" 버튼 클릭
2. **금액 미리 설정**: 
   - 10,000 KRW → USDT
   - 100 USD → USDC
   - 50,000 KRW → USDT
   - 500 USD → USDC
3. **사용자 정의 금액**: 하단 폼에서 원하는 금액과 통화 설정

#### 🔧 고급 기능 테스트
1. **팩토리 함수**: Window/Modal/입금전용/출금전용 위젯
2. **고급 설정**: 다크 테마, 커스텀 크기, 애니메이션
3. **이벤트 콜백**: 성공/실패/닫힘 이벤트 처리

### 3. 테스트 체크리스트

- [ ] 파트너 서버 연결 확인
- [ ] Widget API 토큰 발급 성공
- [ ] 입금 위젯 정상 동작
- [ ] 출금 위젯 정상 동작
- [ ] 체인/토큰 선택 기능
- [ ] 금액 미리 설정 기능
- [ ] 이벤트 콜백 동작
- [ ] 에러 처리 동작
- [ ] 위젯 닫기/열기 동작

## 🔧 설정 옵션

### 위젯 모드
- **Window**: 새 창으로 열기
- **Modal**: 팝업 레이어로 열기

### 테마
- **Light**: 밝은 테마
- **Dark**: 어두운 테마

### 디버그 모드
- **켜기**: 상세 로그 출력
- **끄기**: 기본 로그만 출력

## 📊 모니터링 및 로그

### 실시간 이벤트 로그
- 위젯 열기/닫기
- 성공/실패 이벤트
- 에러 메시지
- API 호출 결과

### 위젯 상태 확인
- 현재 열린 위젯 수
- 위젯 연결 상태
- 토큰 유효성

## 🚨 문제 해결

### 일반적인 문제들

#### 1. 토큰 발급 실패
```
❌ Widget API 오류: 401 Unauthorized
```
**해결 방법:**
- API Key와 Secret 확인
- 서버 시간 동기화 확인
- 네트워크 연결 상태 확인

#### 2. 위젯 UI 로딩 실패
```
❌ 위젯 UI 서버 연결 실패
```
**해결 방법:**
- widget-ui 서버 실행 상태 확인
- 포트 3002 접근 가능 여부 확인
- CORS 설정 확인

#### 3. 파트너 서버 연결 실패
```
❌ 파트너 API 연결 실패
```
**해결 방법:**
- 파트너 데모 서버 실행 상태 확인
- 포트 3001 접근 가능 여부 확인
- 네트워크 방화벽 설정 확인

### 디버그 모드 활성화
```javascript
const widget = new CryptoPaymentsWidget({
    debug: true,  // 상세 로그 출력
    // ... 기타 설정
});
```

## 🔗 관련 링크

- **Widget API 문서**: https://api.cryptoments.net/docs
- **Widget UI**: http://localhost:3002
- **파트너 콘솔**: https://console.cryptoments.net
- **개발자 문서**: https://docs.cryptoments.net

## 📝 개발자 노트

### 서명 생성 방식
```javascript
// HMAC-SHA256 서명 생성
const message = method + path + timestamp;
const signature = crypto.createHmac('sha256', secret).update(message).digest('hex');
```

### 권한 설정
```javascript
const permissions = [
    'DEPOSIT_READ',        // 입금 주소 생성 권한
    'WITHDRAWAL_REQUEST',  // 출금 요청 권한
    'BALANCE_READ',        // 잔액 조회 권한
    'TRANSACTION_READ'     // 거래 내역 조회 권한
];
```

### 환경 변수 (선택사항)
```bash
# .env 파일 생성
PARTNER_ID=1
API_KEY=pk_8dc1b3e4a5754daebdac9b174f133e1f
API_SECRET=sk_ff55ffdb540c4db995b8cd853038a446
PORT=3001
```

## 📄 라이선스

이 프로젝트는 CRYPTOMENTS Inc.의 개발 및 테스트 목적으로 제공됩니다.

---

**💡 팁**: 테스트 중 문제가 발생하면 브라우저 개발자 도구의 콘솔과 네트워크 탭을 확인하세요!
