# 🚀 Crypto Payments Widget Demo - 빠른 시작 가이드

## ⚡ 5분 만에 테스트하기

### 1️⃣ 서버 실행
```bash
cd widget-demo
npm install
npm start
```

### 2️⃣ 브라우저에서 테스트
```
http://localhost:3001/usage-examples
```

### 3️⃣ 기본 테스트
- **입금 위젯**: "입금 위젯 열기" 버튼 클릭
- **출금 위젯**: "출금 위젯 열기" 버튼 클릭

## 🔧 필수 환경

### Widget UI 서버 실행 (별도 터미널)
```bash
cd ../widget-ui
npm run serve
```

### 포트 확인
- **파트너 데모 서버**: 3001
- **Widget UI**: 3002
- **Widget API**: https://api.cryptoments.net

## 🧪 테스트 체크리스트

- [ ] 파트너 서버 실행 ✅
- [ ] Widget UI 서버 실행 ✅
- [ ] 브라우저에서 테스트 페이지 접속 ✅
- [ ] 입금 위젯 테스트 ✅
- [ ] 출금 위젯 테스트 ✅

## 🚨 문제 해결

### 위젯이 열리지 않는 경우
1. Widget UI 서버가 실행 중인지 확인
2. 브라우저 콘솔에서 에러 메시지 확인
3. 네트워크 탭에서 API 호출 상태 확인

### 토큰 발급 실패
1. 파트너 서버 상태 확인: http://localhost:3001/health
2. API Key/Secret 설정 확인
3. 서버 시간 동기화 확인

## 📞 지원

문제가 발생하면 다음을 확인하세요:
1. 브라우저 개발자 도구 콘솔
2. 서버 터미널 로그
3. 네트워크 탭의 API 호출 상태

---

**🎯 목표**: 5분 내에 위젯 테스트 환경 구축 및 기본 기능 테스트 완료!
